﻿Imports Microsoft.VisualBasic

Public Class clsGPE
    'these constants set the command language for GPE
    'const to define the start of a sub procedure
    Private Const CMD_SUB As String = "function"
    'const to define end script
    Private Const CMD_END_SCRIPT As String = "end script"
    'const to define the call command
    Private Const CMD_CALL As String = "call"
    'const for the north command
    Private Const CMD_NORTH As String = "pen.north"
    'const for the south command
    Private Const CMD_SOUTH As String = "pen.south"
    'const for the east command
    Private Const CMD_EAST As String = "pen.east"
    'const for the west command
    Private Const CMD_WEST As String = "pen.west"
    'const for the northwest command
    Private Const CMD_NORTH_WEST As String = "pen.northwest"
    'const for the northeast command
    Private Const CMD_NORTH_EAST As String = "pen.northeast"
    'const for the southwest command
    Private Const CMD_SOUTH_WEST As String = "pen.southwest"
    'const for the southeast command
    Private Const CMD_SOUTH_EAST As String = "pen.southeast"
    'const for the ink command
    Private Const CMD_INK = "pen.ink"
    'const for the jumpto command
    Private Const CMD_JUMP_TO = "pen.jumpto"
    'const for the clear command
    Private Const CMD_CLEAR As String = "screen.clear"

    Private lCanvasSize As Integer
    Private lPenPosition As Integer
    Private lErrString As String
    Private lCanvas As New ArrayList
    Private lInkColour As System.Drawing.Color = System.Drawing.Color.Blue
    Private lInk As String

    Public ReadOnly Property Ink As String
        Get
            Return lInk
        End Get
    End Property

    Public ReadOnly Property TheCanvas As ArrayList
        Get
            Return lCanvas
        End Get
    End Property

    Public Sub New(CanvasSize As Integer)
        lCanvasSize = CanvasSize
    End Sub

    Public Function ErrString() As String
        Return lErrString
    End Function

    Private Function PrepScript(AScript As String) As String
        'convert the script to lower case
        'AScript = LCase(AScript) & vbCrLf
        'add extra spaces around the assignment operator
        AScript = AScript.Replace("=", " = ")
        'add extra spaces after the jumpto command
        AScript = AScript.Replace("jumpto", "jumpto ")
        'get rid of carrage returns
        AScript = AScript.Replace(Chr(10), "")
        AScript = AScript.Replace(Chr(13), "!")
        AScript = RemoveComments(AScript)
        Return AScript
    End Function

    Private Function RemoveComments(ASCript As String) As String
        Dim NewScript As String = ""
        Dim Commands() As String = ASCript.Split("!")
        Dim ArSize As Integer = UBound(Commands)
        For Counter = 0 To Commands.GetUpperBound(0)
            If Left(Commands(Counter), 2) <> "//" Then
                NewScript = NewScript & Commands(Counter)
            End If
        Next
        Return NewScript
    End Function

    Public Function X() As Integer
        'this function returns the value of the x coordinate
        Return lPenPosition - ((Int(lPenPosition / lCanvasSize)) * lCanvasSize)
    End Function

    Public Function Y() As Integer
        'this function returns the value of the y coordinate
        Return Int(lPenPosition / lCanvasSize) + 1
    End Function

    Private Function ExtractFunction(ByVal SubName As String, ByVal AScript As String, ByRef Abort As Boolean) As String
        'this function extracts the code for a sub procedure
        'it accepts three parameters
        'the name of the script to extract
        'the script containing the sub
        'abort is passed by ref in case anything goes wrong
        '
        'var to point to the start of the script
        Dim ScriptStart As Long
        'var to point to the end of the script
        Dim ScriptEnd As Long
        'assume all is well
        Abort = False
        'find the start of the script
        ScriptStart = InStr(AScript, CMD_SUB & " " & SubName & "{")
        'if start found
        If ScriptStart <> 0 Then
            'set the pointer to the start
            ScriptStart = ScriptStart + Len(CMD_SUB) + 2 + Len(SubName)
        Else
            'otherwise display an error message
            lErrString = lErrString & "cannot find " & SubName & vbCrLf
            'abort everything
            Abort = True
        End If
        'find the end of the script
        ScriptEnd = InStr(ScriptStart, AScript, "}", True)
        'if the end of the script not found
        If ScriptEnd = 0 Then
            'display an error
            lErrString = lErrString & "cannot find end function for " & SubName & vbCrLf
            'abort the operation
            Abort = True
        End If
        'if no abort
        If Not Abort Then
            'extract the script
            Return Mid(AScript, ScriptStart, ScriptEnd - ScriptStart)
        Else
            'return a blank string
            Return ""
        End If
    End Function


    Private Function GetRepeats(ByVal ACommand As String) As Integer
        'this function extracts the number of repeats
        'on a direction command eg north 6
        'it requires one parameter which is the full command
        '
        'var to store the number of repeats
        Dim Repeats As String
        'var to store the position of the space
        Dim SpacePosn As Integer
        'strip out the brackets
        ACommand = ACommand.Replace("(", " ")
        ACommand = ACommand.Replace(")", "")
        'get the position of the space
        SpacePosn = InStr(ACommand, " ")
        'get the number of repeats
        Repeats = Right(ACommand, Len(ACommand) - SpacePosn)
        'if it is numeric then 
        If IsNumeric(Repeats) Then
            'return the number of repeats
            Return CInt(Repeats)
        Else
            'otherwise return 1
            Return 1
        End If
    End Function

    Private Function GetCommand(ByVal ACommand As String) As String
        'this function extracts the command from a single line
        'it requires one parameter which is the full command
        '
        'trim the string
        ACommand = Trim(ACommand)
        'var to stor the space position
        Dim SpacePosn As Integer
        'get the space position
        SpacePosn = InStr(ACommand, " ")
        If SpacePosn = 0 Then
            SpacePosn = InStr(ACommand, "(")
        End If
        'if a space is found
        If SpacePosn > 0 Then
            'get everything to the left of the command
            Return Left(ACommand, SpacePosn - 1)
        Else
            'otherwise return a blank string
            Return ACommand
        End If
    End Function

    Private Function GetValue(ByVal ACommand As String) As String
        'this sub gets the value of an assignment operation
        'it accepts one parameter wich is the full command to be executed
        '
        'var to store the position of the = sign
        Dim AssignmentPosn As Integer
        'get the position
        AssignmentPosn = InStr(ACommand, "=")
        'if a = is present
        If AssignmentPosn > 0 Then
            'return the trimmed text to the right of it
            Return Trim(Right(ACommand, Len(ACommand) - AssignmentPosn))
        Else
            'otherwise return a blank string
            Return ""
        End If
    End Function

    Private Function GetFunctionName(ByVal ACommand As String) As String
        'this function extracts the name of a sub from a call command
        'it accepts one parameter which is the full call command to be run
        '
        'var to store the space position
        Dim SpacePosn As Integer
        'get the space position
        SpacePosn = InStr(ACommand, " ")
        'return everything right of the space
        Return Right(ACommand, Len(ACommand) - SpacePosn)
    End Function

    Function GetNewXY(ByVal ScriptName As String, ByVal ACommand As String, ByVal LineNo As Integer, ByRef NewX As Integer, ByRef NewY As Integer) As Boolean
        'this sub extracts the parameters from the jump to commmand
        'it retunrs true or false depending on if this works or not
        'it requires three parameters
        'the name of the current script / sub script
        'the command to be executed including parameters
        'the line number
        'the parameters new x and new y are set by the sub
        '
        'used to point to the open bracket in the string
        Dim OpenBracketPosn As Integer
        'used to point to the close bracket in the string
        Dim CloseBracketPosn As Integer
        'used to store the parameters with the comma
        Dim Parameters As String
        'used to store the position of the comma
        Dim CommaPosn As Integer
        'used to store the new x position
        Dim stNewx As String = ""
        'used to store the new y position
        Dim stNewy As String = ""
        'flags if all is ok
        Dim OK As Boolean = False
        'get the position of the open bracket
        OpenBracketPosn = InStr(ACommand, "(")
        'get the position of the close bracket
        CloseBracketPosn = InStr(ACommand, ")")
        'if both brackets are found and the open is before the close
        If OpenBracketPosn <> 0 And CloseBracketPosn <> 0 And (OpenBracketPosn < CloseBracketPosn) Then
            'get the parameters between the brackets
            Parameters = ACommand.Substring(OpenBracketPosn, CloseBracketPosn - (OpenBracketPosn + 1))
            'find the position of the comma
            CommaPosn = InStr(Parameters, ",")
            'if there is a comma
            If CommaPosn > 0 Then
                'if the first parameter is numeric
                If IsNumeric(Left(Parameters, CommaPosn - 1)) Then
                    'extract it
                    stNewx = Left(Parameters, CommaPosn - 1)
                Else
                    'display an error
                    lErrString = lErrString & Left(Parameters, CommaPosn - 1) & " is not a valid value for an x coordinate, line " & LineNo & " " & ScriptName & vbCrLf
                End If
                'if the second parameter is numeric
                If IsNumeric(Right(Parameters, Len(Parameters) - CommaPosn)) Then
                    'extract it
                    stNewy = Right(Parameters, Len(Parameters) - CommaPosn)
                Else
                    'display an error
                    lErrString = lErrString & Right(Parameters, Len(Parameters) - CommaPosn) & " is not a valid value for a y coordinate, line " & LineNo & " " & ScriptName & vbCrLf
                End If
                'if both extracted parameters are numeric
                If IsNumeric(stNewx) And IsNumeric(stNewy) Then
                    'set the value of new x
                    NewX = stNewx
                    'set the value of new y
                    NewY = stNewy
                    'flag ok as true
                    OK = True
                End If
            Else
                'show there is an error due to missing comma
                lErrString = lErrString & "Comma missing in " & CMD_JUMP_TO & " command, line " & LineNo & " " & ScriptName & vbCrLf
            End If
        Else
            'show there is a problem with the brackets
            lErrString = lErrString & "Bracket error in " & CMD_JUMP_TO & " command, line " & LineNo & " " & ScriptName & vbCrLf
        End If
        Return OK
    End Function


    Sub MovePen(ByVal Direction As String, ByVal Repeats As Integer)
        'this sub calls the appropriate sub based on the direction command
        'passed as a parameter
        Dim Counter As Integer
        '
        'loop for the number of times to repeat
        For Counter = 1 To Repeats
            'if command is north
            If Direction = CMD_NORTH Then
                'move north
                Call MoveNorth()
                'if command is south
            ElseIf Direction = CMD_SOUTH Then
                'move south
                Call MoveSouth()
                'if command is east
            ElseIf Direction = CMD_EAST Then
                'move east
                Call MoveEast()
                'if command is west
            ElseIf Direction = CMD_WEST Then
                'move west
                Call MoveWest()
                'if command is north east
            ElseIf Direction = CMD_NORTH_EAST Then
                'move north east
                Call MoveNorthEast()
                'if command is north west
            ElseIf Direction = CMD_NORTH_WEST Then
                'move north west
                Call MoveNorthWest()
                'if command is south east
            ElseIf Direction = CMD_SOUTH_EAST Then
                'move south east
                Call MoveSouthEast()
                'if command is south west
            ElseIf Direction = CMD_SOUTH_WEST Then
                'move south west
                Call MoveSouthWest()
            End If
        Next
    End Sub

    Public Sub MoveEast()
        'this sub moves the pointer east
        '
        'set the last position of the pen to the current ink colour
        lCanvas(lPenPosition - 1) = lInkColour
        'if the new pen position is still within the canvas
        If lPenPosition < (lCanvasSize * lCanvasSize) Then
            'move the pen
            lPenPosition += 1
        End If
        'mark the pen on the canvas
        lCanvas(lPenPosition - 1) = System.Drawing.Color.Black
    End Sub

    Public Sub MoveWest()
        'this sub moves the pointer west
        '
        'set the last position of the pen to the current ink colour
        lCanvas(lPenPosition - 1) = lInkColour
        'if the new pen position is still within the canvas
        If lPenPosition > 1 Then
            'move the pen
            lPenPosition -= 1
        End If
        'mark the pen on the Canvas
        lCanvas(lPenPosition - 1) = System.Drawing.Color.Black
    End Sub

    Public Sub MoveNorth()
        'this sub moves the pointer north
        '
        'set the last position of the pen to the current ink colour
        lCanvas(lPenPosition - 1) = lInkColour
        'if the new pen position is still within the Canvas
        If (lPenPosition - lCanvasSize) >= 1 Then
            'move the pen
            lPenPosition -= lCanvasSize
        End If
        'mark the pen on the Canvas
        lCanvas(lPenPosition - 1) = System.Drawing.Color.Black
    End Sub

    Public Sub MoveSouth()
        'this sub moves the pointer south
        '
        'set the last position of the pen to the current ink colour
        lCanvas(lPenPosition - 1) = lInkColour
        'if the new pen position is still within the canvas
        If (lPenPosition + lCanvasSize) <= (lCanvasSize * lCanvasSize) Then
            'move the pen
            lPenPosition += lCanvasSize
        End If
        'mark the pen on the canvas
        lCanvas(lPenPosition - 1) = System.Drawing.Color.Black
    End Sub

    Public Sub MoveNorthEast()
        'this sub moves the pointer north east
        '
        'set the last position of the pen to the current ink colour
        lCanvas(lPenPosition - 1) = lInkColour
        'if the new pen position is still within the canvas
        If ((lPenPosition - lCanvasSize) > 1) And (lPenPosition < (lCanvasSize * lCanvasSize)) Then
            'move the pen
            lPenPosition -= (lCanvasSize - 1)
        End If
        'mark the pen on the canvas
        lCanvas(lPenPosition - 1) = System.Drawing.Color.Black
    End Sub

    Public Sub MoveNorthWest()
        'this sub moves the pointer north west
        '
        'set the last position of the pen to the current ink colour
        lCanvas(lPenPosition - 1) = lInkColour
        'if the new pen position is still within the canvas
        If ((lPenPosition - lCanvasSize) > 1) And (lPenPosition > 1) Then
            'move the pen
            lPenPosition -= (lCanvasSize + 1)
        End If
        'mark the pen on the canvas
        lCanvas(lPenPosition - 1) = System.Drawing.Color.Black
    End Sub

    Public Sub MoveSouthEast()
        'this sub moves the pointer south east
        '
        'set the last position of the pen to the current ink colour
        lCanvas(lPenPosition - 1) = lInkColour
        'if the new pen position is still within the canvas
        If ((lPenPosition + lCanvasSize) < (lCanvasSize * lCanvasSize)) And (lPenPosition < (lCanvasSize * lCanvasSize)) Then
            'move the pen
            lPenPosition += (lCanvasSize + 1)
        End If
        'mark the pen on the canvas
        lCanvas(lPenPosition - 1) = System.Drawing.Color.Black
    End Sub

    Public Sub MoveSouthWest()
        'this sub moves the pointer south west
        '
        'set the last position of the pen to the current ink colour
        lCanvas(lPenPosition - 1) = lInkColour
        'if the new pen position is still within the canvas
        If ((lPenPosition + lCanvasSize) <= (lCanvasSize * lCanvasSize)) And (lPenPosition > 1) Then
            'move the pen
            lPenPosition += (lCanvasSize - 1)
        End If
        'mark the pen on the canvas
        lCanvas(lPenPosition - 1) = System.Drawing.Color.Black
    End Sub


    Public Sub JumpTo(ByVal X As Integer, ByVal Y As Integer)
        'set the old pen position to the current ink colour
        lCanvas(lPenPosition - 1) = lInkColour
        'if the new pen position is still within the canvas
        If ((((Y - 1) * lCanvasSize) + X) >= 1) And ((((Y - 1) * lCanvasSize) + X) <= (lCanvasSize * lCanvasSize)) Then
            'move the pen position
            lPenPosition = ((Y - 1) * lCanvasSize) + X
        Else
            'display an error message
            lErrString = lErrString & CMD_JUMP_TO & " " & X & "," & Y & " takes pointer put of the grid" & vbCrLf
        End If
        'set the new position of the pen to the pen colour
        lCanvas(lPenPosition - 1) = System.Drawing.Color.Black
    End Sub

    'this section of code is used in week 7 session 1
    'it shows how an if then elseif structure behaves with different values of ink
    Public Sub SetInk(ByVal SelectedInk As String)
        'this sub sets the ink colour of the pen
        'it accepts on parameter stating the ink colour as a string
        '
        'display the new ink colour on th epage
        lInk = "Ink=" & SelectedInk
        'if the ink is black
        If SelectedInk = "black" Then
            'set the pen colour to black
            lInkColour = System.Drawing.Color.Black
            'if the ink is red
        ElseIf SelectedInk = "red" Then
            'set the pen colour to red
            lInkColour = System.Drawing.Color.Red
            'if the ink is blue
        ElseIf SelectedInk = "blue" Then
            'set the pen colour to blue
            lInkColour = System.Drawing.Color.Blue
            'if the ink is green
        ElseIf SelectedInk = "green" Then
            'set the pen colour to green
            lInkColour = System.Drawing.Color.Green
            'if the ink is white
        ElseIf SelectedInk = "white" Then
            'set the pen colour to white
            lInkColour = System.Drawing.Color.White
        Else
            'display an error
            lInk = ""
        End If
    End Sub

    Public Sub ClearAll()
        'this sub clears the canvas
        Dim Count As Integer
        'loop through each element in the canvas
        For Count = 0 To lCanvas.Count - 1
            'set the cell to white
            lCanvas(Count) = System.Drawing.Color.White
        Next
        'draw the pen
        lCanvas(lPenPosition - 1) = System.Drawing.Color.Black
    End Sub

    Public Function IsDirection(ByVal CommandToRun As String) As Boolean
        'this function checks to see if a command is a direction commend eg N S E W
        'it accepts one parameter - the command to run
        '
        'var to store ok - assume it is not ok
        Dim OK As Boolean = False
        'if the command is north
        If CommandToRun = CMD_NORTH Then
            'set ok to true
            OK = True
            'if the command is south
        ElseIf CommandToRun = CMD_SOUTH Then
            'set ok to true
            OK = True
            'if the command is east
        ElseIf CommandToRun = CMD_EAST Then
            'set ok to true
            OK = True
            'if the command is west
        ElseIf CommandToRun = CMD_WEST Then
            'set ok to true
            OK = True
            'if the command is north east
        ElseIf CommandToRun = CMD_NORTH_EAST Then
            'set ok to true
            OK = True
            'if the command is north east
        ElseIf CommandToRun = CMD_NORTH_WEST Then
            'set ok to true
            OK = True
            'if the command is south east
        ElseIf CommandToRun = CMD_SOUTH_EAST Then
            'set ok to true
            OK = True
            'if the command is south west
        ElseIf CommandToRun = CMD_SOUTH_WEST Then
            'set ok to true
            OK = True
        End If
        'return the state of ok
        Return OK
    End Function

    Public Sub InitialiseCanvas()
        'this sub initialises the array containing the canvas
        '
        'var to store the number of the current element
        Dim Element As Integer
        'loop through each element in the array
        For Element = 0 To (lCanvasSize * lCanvasSize) - 1
            'create a new canvas element
            Dim ACell As New System.Drawing.Color
            'set the cell colour to white
            ACell = System.Drawing.Color.White
            'add the cell to the baord
            lCanvas.Add(ACell)
        Next
        'set the pen to the top left hand corner
        lPenPosition = 1
        'jump to top left hand corner
        Call JumpTo(1, 1)
    End Sub

    Public Sub RunCommand(ByVal ACommand As String, ByVal AScript As String, ByVal LineNo As Long, ByVal SubName As String)
        'this sub processes individual commands
        'it accepts three parameters
        'the command to be run
        'the script
        'the current line number
        'the name of the current sub procedure if appropriate
        '
        'var to contain the actual command to be run (without parameters etc)
        Dim CommandToRun As String
        'name of the new ink colour
        Dim NewInk As String
        'used in the jump to command
        Dim NewxPosn As Integer
        'used in the jump to command
        Dim NewyPosn As Integer
        'used to store the code for a sub script
        Dim SubScriptCode As String
        'used to flag if code should be executed or not
        Static NoRun As Boolean
        'used to abort processing if there is a problem
        Dim Abort As Boolean
        'flag that any script processing will be a fresh start
        Dim StartScript As Boolean = True
        'var to store the number of times a command should repeat
        Dim Repeats As Integer
        'get the actual command to run
        CommandToRun = GetCommand(ACommand)
        'if we are still running commands
        If Not NoRun Then
            'if the command is a direction comand eg n s e w
            If IsDirection(CommandToRun) = True Then
                'get the number of repeats on the direction
                Repeats = GetRepeats(ACommand)
                'move the pen
                Call MovePen(CommandToRun, Repeats)
                'if the command is an ink command
            ElseIf CommandToRun = CMD_INK Then
                'get the new ink colour
                NewInk = GetValue(ACommand)
                'if an ink has been specified 
                If NewInk <> "" Then
                    'set the ink
                    Call SetInk(NewInk)
                Else
                    'otherwise show an error
                    lErrString = lErrString & "missing assignment operator in line " & LineNo & " " & SubName & vbCrLf
                End If
                'if the command is a jumpto command
            ElseIf CommandToRun = CMD_JUMP_TO Then
                'get the new x and y assuming all is well
                If GetNewXY(SubName, ACommand, LineNo, NewxPosn, NewyPosn) = True Then
                    'if all is well then jump to that position
                    Call JumpTo(CInt(NewxPosn), CInt(NewyPosn))
                End If
                'if the command is clear 
            ElseIf CommandToRun = CMD_CLEAR Then
                'call the clear sub
                Call ClearAll()
                'if the command is the name of a sub then stop processing
            ElseIf CommandToRun = CMD_SUB Then
                'turn off command processing
                NoRun = True
                'if the command is a call
            ElseIf CommandToRun = CMD_CALL Then
                'get the name of the sub to run
                SubName = GetFunctionName(ACommand)
                'extract the code for that sub
                SubScriptCode = ExtractFunction(SubName, AScript, Abort)
                'if no problems
                If Not Abort Then
                    'run the sub script
                    Call RunScript(SubScriptCode, CMD_SUB & " " & SubName)
                End If
            Else
                'if the command is not a blank line or a comment
                If CommandToRun <> "" And Left(CommandToRun, 1) <> "'" Then
                    'display an error message stating command not known
                    lErrString = lErrString & CommandToRun & " not a known command, line " & LineNo & " " & SubName & vbCrLf
                End If
            End If
        End If
        'if the current line is an end (end sub or end script)
        If Left(ACommand, 3) = "end" Then
            'turn on processing
            NoRun = False
        End If
    End Sub

    Public Sub RunScript(ByVal FullScript As String, ByVal SubScriptName As String)
        'this sub is used to process a script / subscript
        'it accepts three parameters 
        'a boolean flag to indicate that this is the start of a script and not a sub script
        'the script itself
        'the name of any sub script to be run
        '
        'clear any previous errors messages
        lErrString = ""
        'static variable to store the new position pointer in the string 
        Dim NewPosn As Integer = 1
        'static variable to store the old psotion pointer in the string
        Dim OldPosn As Integer = 1
        'static var to store the line number being processed
        Dim LineNo As Long = 0
        'var to store the text of the current command
        Dim CommandText As String
        FullScript = PrepScript(FullScript)
        'loop while the script is not done
        While NewPosn < Len(FullScript) 'NotDone = True
            'increase the new position pointer
            NewPosn += 1
            'the character at new position is a line feed character
            If Mid(FullScript, NewPosn, 1) = ";" Then
                'get the text between old position and new position
                CommandText = Mid(FullScript, OldPosn, (NewPosn - OldPosn))
                'move old position 1 char beyond new position
                OldPosn = NewPosn + 1
                'increase the line number
                LineNo += 1
                'if the command is not marking the end of the script
                If CommandText <> CMD_END_SCRIPT Then
                    'run the command
                    Call RunCommand(CommandText, FullScript, LineNo, SubScriptName)
                Else
                    'send new position to the end of the script
                    NewPosn = Len(FullScript)
                End If
            End If
        End While
    End Sub
End Class
